/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.diskdrive;

import com.google.errorprone.annotations.concurrent.GuardedBy;
import dan200.computercraft.api.filesystem.Mount;
import dan200.computercraft.api.filesystem.WritableMount;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.shared.common.AbstractContainerBlockEntity;
import dan200.computercraft.shared.network.client.PlayRecordClientMessage;
import dan200.computercraft.shared.network.server.ServerNetworking;
import dan200.computercraft.shared.peripheral.diskdrive.DiskDriveBlock;
import dan200.computercraft.shared.peripheral.diskdrive.DiskDriveMenu;
import dan200.computercraft.shared.peripheral.diskdrive.DiskDrivePeripheral;
import dan200.computercraft.shared.peripheral.diskdrive.DiskDriveState;
import dan200.computercraft.shared.peripheral.diskdrive.MediaStack;
import dan200.computercraft.shared.util.WorldUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import org.jspecify.annotations.Nullable;

public final class DiskDriveBlockEntity
extends AbstractContainerBlockEntity {
    private static final String NBT_ITEM = "Item";
    private final DiskDrivePeripheral peripheral = new DiskDrivePeripheral(this);
    private final class_2371<class_1799> inventory = class_2371.method_10213((int)1, (Object)class_1799.field_8037);
    @GuardedBy(value="this")
    private final Map<IComputerAccess, MountInfo> computers = new HashMap<IComputerAccess, MountInfo>();
    @GuardedBy(value="this")
    private MediaStack media = MediaStack.EMPTY;
    @GuardedBy(value="this")
    private @Nullable Mount mount;
    private boolean recordPlaying = false;
    private final AtomicReference<RecordCommand> recordQueued = new AtomicReference<Object>(null);
    private final AtomicBoolean ejectQueued = new AtomicBoolean(false);
    private final AtomicBoolean stackDirty = new AtomicBoolean(false);

    public DiskDriveBlockEntity(class_2591<DiskDriveBlockEntity> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    public IPeripheral peripheral() {
        return this.peripheral;
    }

    public void method_10996() {
        super.method_10996();
        this.updateMedia();
    }

    public void method_11012() {
        super.method_11012();
        if (this.recordPlaying) {
            this.stopRecord();
        }
    }

    public class_2350 getDirection() {
        return (class_2350)this.method_11010().method_11654((class_2769)DiskDriveBlock.FACING);
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.setDiskStack(nbt.method_10545(NBT_ITEM) ? class_1799.method_7915((class_2487)nbt.method_10562(NBT_ITEM)) : class_1799.field_8037);
    }

    public void method_11007(class_2487 tag) {
        super.method_11007(tag);
        class_1799 stack = this.getDiskStack();
        if (!stack.method_7960()) {
            tag.method_10566(NBT_ITEM, (class_2520)stack.method_7953(new class_2487()));
        }
    }

    void serverTick() {
        RecordCommand recordQueued;
        if (this.stackDirty.getAndSet(false)) {
            this.updateDiskFromMedia();
        }
        if (this.ejectQueued.getAndSet(false)) {
            this.ejectContents();
        }
        if ((recordQueued = (RecordCommand)this.recordQueued.getAndSet(null)) != null) {
            switch (recordQueued.ordinal()) {
                case 0: {
                    MediaStack media = this.getMedia();
                    class_3414 record = media.getAudio();
                    if (record == null) break;
                    this.recordPlaying = true;
                    String title = media.getAudioTitle();
                    this.sendMessage(new PlayRecordClientMessage(this.method_11016(), record, title));
                    break;
                }
                case 1: {
                    this.stopRecord();
                    this.recordPlaying = false;
                }
            }
        }
    }

    public class_2371<class_1799> getContents() {
        return this.inventory;
    }

    public void method_5431() {
        if (this.field_11863 != null && !this.field_11863.field_9236) {
            this.updateMedia();
        }
        super.method_5431();
    }

    private synchronized void updateMedia() {
        class_1799 newStack = this.getDiskStack();
        if (class_1799.method_31577((class_1799)newStack, (class_1799)this.media.stack())) {
            return;
        }
        MediaStack newMedia = MediaStack.of(newStack);
        if (newStack.method_7960()) {
            this.updateBlockState(DiskDriveState.EMPTY);
        } else {
            this.updateBlockState(newMedia.media() != null ? DiskDriveState.FULL : DiskDriveState.INVALID);
        }
        if (!this.media.stack().method_7960()) {
            for (Map.Entry<IComputerAccess, MountInfo> computer : this.computers.entrySet()) {
                DiskDriveBlockEntity.unmountDisk(computer.getKey(), computer.getValue());
            }
        }
        if (this.recordPlaying) {
            this.stopRecord();
            this.recordPlaying = false;
        }
        this.mount = null;
        this.media = newMedia;
        this.stackDirty.set(false);
        if (!newStack.method_7960() && !this.computers.isEmpty()) {
            Mount mount = this.getOrCreateMount(true);
            for (Map.Entry<IComputerAccess, MountInfo> entry : this.computers.entrySet()) {
                DiskDriveBlockEntity.mountDisk(entry.getKey(), entry.getValue(), mount);
            }
        }
    }

    class_1799 getDiskStack() {
        return this.method_5438(0);
    }

    synchronized MediaStack getMedia() {
        return this.media;
    }

    void setDiskStack(class_1799 stack) {
        this.method_5447(0, stack);
        this.method_5431();
    }

    private synchronized void updateDiskFromMedia() {
        this.method_5447(0, this.media.stack().method_7972());
        super.method_5431();
    }

    @GuardedBy(value="this")
    private void updateMediaStack(class_1799 stack, boolean immediate) {
        if (class_1799.method_31577((class_1799)this.media.stack(), (class_1799)stack)) {
            return;
        }
        this.media = new MediaStack(stack, this.media.media());
        if (immediate) {
            this.updateDiskFromMedia();
        } else {
            this.stackDirty.set(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable String getDiskMountPath(IComputerAccess computer) {
        DiskDriveBlockEntity diskDriveBlockEntity = this;
        synchronized (diskDriveBlockEntity) {
            MountInfo info = this.computers.get(computer);
            return info != null ? info.mountPath : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void attach(IComputerAccess computer) {
        DiskDriveBlockEntity diskDriveBlockEntity = this;
        synchronized (diskDriveBlockEntity) {
            MountInfo info = new MountInfo();
            this.computers.put(computer, info);
            if (!this.media.stack().method_7960()) {
                class_3218 l;
                class_1937 class_19372 = this.field_11863;
                DiskDriveBlockEntity.mountDisk(computer, info, this.getOrCreateMount(class_19372 instanceof class_3218 && (l = (class_3218)class_19372).method_8503().method_18854()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void detach(IComputerAccess computer) {
        DiskDriveBlockEntity diskDriveBlockEntity = this;
        synchronized (diskDriveBlockEntity) {
            DiskDriveBlockEntity.unmountDisk(computer, this.computers.remove(computer));
        }
    }

    void playDiskAudio() {
        this.recordQueued.set(RecordCommand.PLAY);
    }

    void stopDiskAudio() {
        this.recordQueued.set(RecordCommand.STOP);
    }

    void ejectDisk() {
        this.ejectQueued.set(true);
    }

    synchronized MountResult setDiskLabel(@Nullable String label) {
        if (this.media.media() == null) {
            return MountResult.NO_MEDIA;
        }
        class_1799 stack = this.media.stack().method_7972();
        if (!this.media.media().setLabel(stack, label)) {
            return MountResult.NOT_ALLOWED;
        }
        this.updateMediaStack(stack, true);
        return MountResult.CHANGED;
    }

    @GuardedBy(value="this")
    private @Nullable Mount getOrCreateMount(boolean immediate) {
        if (this.media.media() == null) {
            return null;
        }
        if (this.mount != null) {
            return this.mount;
        }
        class_1799 stack = this.media.stack().method_7972();
        this.mount = this.media.media().createDataMount(stack, (class_3218)this.method_10997());
        this.updateMediaStack(stack, immediate);
        return this.mount;
    }

    private static void mountDisk(IComputerAccess computer, MountInfo info, @Nullable Mount mount) {
        if (mount instanceof WritableMount) {
            WritableMount writable = (WritableMount)mount;
            int n = 1;
            while (info.mountPath == null) {
                info.mountPath = computer.mountWritable((String)(n == 1 ? "disk" : "disk" + n), writable);
                ++n;
            }
        } else if (mount != null) {
            int n = 1;
            while (info.mountPath == null) {
                info.mountPath = computer.mount((String)(n == 1 ? "disk" : "disk" + n), mount);
                ++n;
            }
        } else assert (info.mountPath == null) : "Mount path should be null";
        computer.queueEvent("disk", computer.getAttachmentName());
    }

    private static void unmountDisk(IComputerAccess computer, MountInfo info) {
        if (info.mountPath != null) {
            computer.unmount(info.mountPath);
            info.mountPath = null;
        }
        computer.queueEvent("disk_eject", computer.getAttachmentName());
    }

    private void updateBlockState(DiskDriveState state) {
        class_2680 blockState = this.method_11010();
        if (blockState.method_11654(DiskDriveBlock.STATE) == state) {
            return;
        }
        this.method_10997().method_8501(this.method_11016(), (class_2680)blockState.method_11657(DiskDriveBlock.STATE, (Comparable)((Object)state)));
    }

    private void ejectContents() {
        if (this.method_10997().field_9236) {
            return;
        }
        class_1799 stack = this.getDiskStack();
        if (stack.method_7960()) {
            return;
        }
        this.setDiskStack(class_1799.field_8037);
        WorldUtil.dropItemStack(this.method_10997(), this.method_11016(), this.getDirection(), stack);
        this.method_10997().method_20290(1000, this.method_11016(), 0);
    }

    private void stopRecord() {
        this.sendMessage(new PlayRecordClientMessage(this.method_11016()));
    }

    private void sendMessage(PlayRecordClientMessage message) {
        ServerNetworking.sendToAllAround(message, (class_3218)this.method_10997(), class_243.method_24953((class_2382)this.method_11016()), 64.0f);
    }

    protected class_1703 method_5465(int id, class_1661 inventory) {
        return new DiskDriveMenu(id, inventory, this);
    }

    private static enum RecordCommand {
        PLAY,
        STOP;

    }

    private static final class MountInfo {
        @Nullable String mountPath;

        private MountInfo() {
        }
    }

    static enum MountResult {
        NO_MEDIA,
        NOT_ALLOWED,
        CHANGED;

    }
}

